@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2> Show Content</h2>
        </div>
        <div class="pull-right">
            <a class="btn btn-primary" href="{{ route('contents.index') }}"> Back</a>
        </div>
    </div>
</div>

<div class="row">

    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Title:</strong>
            {{ $content->title }}
        </div>
    </div>

    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Description:</strong>
            {{ $content->description }}
        </div>
    </div>

    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Images:</strong>

            @php 
                if(!empty($content->images)):
                    $images = json_decode($content->images);
                    foreach($images as $image):
                        @endphp 
                        <a href="{{ asset('contents/'.$image)}}" target="_blank">
                            <img src="{{ asset('contents/'.$image)}}" alt="{{ $image }}" style="width: 50px;" />
                    </a>
                        @php 
                    endforeach;

                endif;
                @endphp 
        </div>
    </div>


    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Created By:</strong>
            {{ App\Models\User::where('id',$content->created_by)->first()->name ?? '' }}
        </div>
    </div>


    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Updated By:</strong>
            {{ App\Models\User::where('id',$content->updated_by)->first()->name ?? ''}}
        </div>
    </div>


    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Status:</strong>
            {{ ucfirst($content->status) }}
        </div>
    </div>


</div>
@endsection
